*********************************
* This is a Stata dofile for the paper: 
* "How Much Did the 2009 Australian Fiscal Stimulus Boost Demand? Evidence from Household-Reported Spending Effects"
* Published in the B.E. Journal of Macroeconomics, 2012
* Please feel free to use or adapt this dofile, so long as you cite that paper.
* Questions to andrew_leigh@ksg02.harvard.edu.
**********************************

clear
version 11
set more off
use "C:\Documents and Settings\leigha\Datasets\ANU Poll\anu_poll_economic_policy_june_2009_final_17jul2009.dta", clear
cd "C:\Documents and Settings\leigha\My publications\Aust - 2008-09 fiscal stimulus\"

tab c2 [aw=weight0]

gen receiver=0 if c2<=2
replace receiver=1 if c2==1

tabstat receiver [aw=weight0] if dem2==2 | dem2==3,by(dem9a)
tabstat receiver [aw=weight0] if dem2~=2 & dem2~=3,by(dem9a)

gen spenders1=(c3==1)
replace spenders1=. if c3>=8
 
gen spend_save_debt=1 if c3==1
replace spend_save_debt=2 if c3==6 | c3==7
replace spend_save_debt=3 if c3>=2 & c3<=5

gen age65=0 if dem56<=5
replace age65=1 if dem56>=6 & dem56<=7

gen child_u18=0 if dem2a5~=1 & dem2a6~=1
for num 1/3: replace child_u18=1 if dem2aX==1

* Responding person aged 65+ & retired. Household income<$40,000
gen lowincomeretiree=0
replace lowincomeretiree=1 if (dem56>=6 & dem56<=.) & dem8==4 & dem9a<=2

* Responding person aged 25-54 & working. Household has no kids, household income<$80,000
gen youngpoornokids=0
replace youngpoornokids=1 if dem56>=2 & dem56<=4 & (dem2==1 | dem2==5) & (dem8==1 | dem8==2) & dem9a<=4

log using tables.smcl, replace
tab c3 [aw=weight0]
tab spend_save_debt [aw=weight0]
tab spenders1 [aw=weight0]
sum spenders* [aw=weight0]
log close

* By demographics - univariate
log using tables.smcl, append
for any dem9a b3 e3 e6 dem56: tabstat spenders1 [aw=weight0], by(X) stat(mean n) \ qui xi, noomit: reg spenders1 i.X, nocons \ testparm _I*,equal \ 

* By demographics - multivariate
qui xi, noomit: reg spenders1 i.dem9a i.b3 i.e3 i.e6 i.dem56, nocons
for any dem9a b3 e3 e6 dem56: testparm _IX*,equal
log close

* Analysing over-65s and families with children
for any age65 : tabstat spenders1 [aw=weight0], by(X) stat(mean n) \ qui xi, noomit: reg spenders1 i.X, nocons \ testparm _I*,equal \ 
for any child_u18: tabstat spenders1 [aw=weight0] if lowincomeretiree==0, by(X) stat(mean n) \ qui xi, noomit: reg spenders1 i.X  if lowincomeretiree==0, nocons \ testparm _I*,equal \ 
for any lowincomeretiree: tabstat spenders1 [aw=weight0] if child_u18==0, by(X) stat(mean n) \ qui xi, noomit: reg spenders1 i.X  if child_u18==0, nocons \ testparm _I*,equal \ 
qui xi, noomit: reg spenders1 i.dem9a i.b3 i.e3 i.e6 i.age65, nocons
for any dem9a b3 e3 e6 age65: testparm _IX*,equal

* A subset who were likely to be eligible for 2008 bonus and ineligible for 2009 bonus? (low income retirees)
tab c2 if lowincomeretiree==1 [aw=weight0]

* A subset who were likely to be ineligible for 2008 bonus and eligible for 2009 bonus? (low income, young, no kids)
tab c2 if youngpoornokids==1 [aw=weight0]

* Tabulating spending for both groups
for any lowincomeretiree youngpoornokids: tab spend_save_debt if X==1 [aw=weight0]

graph bar (mean) spenders1 [aweight = weight0], over(dem9a, label(angle(vertical))) legend(off) yline(.404)

